


public class GameOfLife {

	private static final int HEIGHT = 4;
	private static final int WIDTH = 4;



	    int [][] world;
	    int [][] otherWorld;
	    Boolean toggle;
	    Shape shape;

	GameOfLife( Shape sh ) 
	{
		shape = sh;
		toggle = true;
	    world = new int[HEIGHT][WIDTH] ;
	    otherWorld = new int[HEIGHT][WIDTH];

	    for ( int i = 0; i < HEIGHT; i++ ) {
	        for ( int j = 0; j < WIDTH; j++ ) {
	            world[i][j] = '.';
	        }
	    }
	    for ( int i = shape.yCoord; i - shape.yCoord < shape.height; i++ ) {
	        for ( int j = shape.xCoord; j - shape.xCoord < shape.width; j++ ) {
	            if ( i < HEIGHT && j < WIDTH ) {
	                world[i][j] =
	                    shape.figure[ i - shape.yCoord ][j - shape.xCoord ];
	            }
	        }
	    }
	}

	void print() {
	    if ( toggle ) {
	        for ( int i = 0; i < HEIGHT; i++ ) {
	            for ( int j = 0; j < WIDTH; j++ ) {
	                System.out.print( (char)world[i][j]);
	            }
	            System.out.println();
	        }
	    } else {
	        for ( int i = 0; i < HEIGHT; i++ ) {
	            for ( int j = 0; j < WIDTH; j++ ) {
	            	System.out.print( (char)otherWorld[i][j]);
	            }
	            System.out.println();
	        }
	    }
	    for ( int i = 0; i < WIDTH; i++ ) {
	    	System.out.print( '=');
	    }
        System.out.println();
	}

	void update() {
	    if (toggle) {
	        for ( int i = 0; i < HEIGHT; i++ ) {
	            for ( int j = 0; j < WIDTH; j++ ) {
	                otherWorld[i][j] =
	                    getState(world[i][j] , i , j , toggle);
	            }
	        }
	        toggle = !toggle;
	    } else {
	        for ( int i = 0; i < HEIGHT; i++ ) {
	            for ( int j = 0; j < WIDTH; j++ ) {
	                world[i][j] =
	                    getState(otherWorld[i][j] , i , j , toggle);
	            }
	        }
	        toggle = !toggle;
	    }
	}

	int getState( int state, int yCoord, int xCoord, Boolean toggle ) {
	    int neighbors = 0;
	    if ( toggle ) {
	        for ( int i = yCoord - 1; i <= yCoord + 1; i++ ) {
	            for ( int j = xCoord - 1; j <= xCoord + 1; j++ ) {
	                if ( i == yCoord && j == xCoord ) {
	                    continue;
	                }
	                if ( i > -1 && i < HEIGHT && j > -1 && j < WIDTH ) {
	                    if ( world[i][j] == 'X' ) {
	                        neighbors++;
	                    }
	                }
	            }
	        }
	    } else {
	        for ( int i = yCoord - 1; i <= yCoord + 1; i++ ) {
	            for ( int j = xCoord - 1; j <= xCoord + 1; j++ ) {
	                if ( i == yCoord && j == xCoord ) {
	                    continue;
	                }
	                if ( i > -1 && i < HEIGHT && j > -1 && j < WIDTH ) {
	                    if ( otherWorld[i][j] == 'X' ) {
	                        neighbors++;
	                    }
	                }
	            }
	        }
	    }
	    if (state == 'X') {
	        return ( neighbors > 1 && neighbors < 4 ) ? 'X' : '.';
	    }
	    else {
	        return ( neighbors == 3 ) ? 'X' : '.';
	    }
	}

	void iterate( int iterations ) {
	    for ( int i = 0; i < iterations; i++ ) {
	        print();
	        update();
	    }
	}



	
	
}
